* bark_beetle_experiment_ttest.sas;
title "Two-sample t test for bark beetle trapping experiment";
data bark_beetle;
	input treat $ count;
	* Apply transformations here;
	y = log10(count);
	datalines; 
A   373
A   126
A   255
A   138
A   379
B    25
B    64
B    62
B    71
B    54
;
run;
* Print data set;
proc print data=bark_beetle;
run;
* Plot means, standard errors, and observations;
proc gplot data=bark_beetle;
	plot y*treat=1 / vaxis=axis1 haxis=axis1;
	symbol1 i=std1mjt v=star height=2 width=3;
	axis1 label=(height=2) value=(height=2) width=3 major=(width=2) minor=none;
run;
* Two-sample t test;
proc ttest data=bark_beetle;
	class treat;
	var y;
run;
quit;
